/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.actions.common;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.FireAmmoAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class PickAmmoAndFireAction
extends AbstractGameAction {
    private AbstractMonster target;
    private AbstractPlayer player;
    private int fireCount;
    private boolean randomTargets;

    public PickAmmoAndFireAction(AbstractPlayer p, AbstractMonster t) {
        this(p, t, 1);
    }

    public PickAmmoAndFireAction(AbstractPlayer p, AbstractMonster t, int numFired) {
        this(p, t, numFired, false);
    }

    public PickAmmoAndFireAction(AbstractPlayer p, AbstractMonster t, int numFired, boolean isRandomTargets) {
        this.target = t;
        this.player = p;
        this.duration = Settings.ACTION_DUR_FAST;
        this.actionType = AbstractGameAction.ActionType.CARD_MANIPULATION;
        this.fireCount = numFired;
        this.randomTargets = isRandomTargets;
    }

    @Override
    public void update() {
        if (this.duration == Settings.ACTION_DUR_FAST) {
            AbstractDungeon.handCardSelectScreen.open("Pick a card to Fire.", 1, false);
            this.tickDuration();
            return;
        }
        if (!AbstractDungeon.handCardSelectScreen.wereCardsRetrieved) {
            for (AbstractCard c : AbstractDungeon.handCardSelectScreen.selectedCards.group) {
                for (int i = 0; i < this.fireCount; ++i) {
                    if (this.randomTargets) {
                        AbstractDungeon.actionManager.addToBottom(new FireAmmoAction(this.player, AbstractDungeon.getMonsters().getRandomMonster(true), c));
                        continue;
                    }
                    AbstractDungeon.actionManager.addToBottom(new FireAmmoAction(this.player, this.target, c));
                }
            }
            AbstractDungeon.player.hand.refreshHandLayout();
            AbstractDungeon.handCardSelectScreen.wereCardsRetrieved = true;
            this.isDone = true;
        }
        this.tickDuration();
    }

    private boolean isFirstStep() {
        return !AbstractDungeon.handCardSelectScreen.wereCardsRetrieved;
    }
}

